//  Listing 11.5. Zastosowanie konstruktora kopii do zainicjowania jednego obiektu 
// przy wykorzystaniu danych z innego obiektu

#include <iostream>
using namespace std;

class String 
{
char *str; 				// dynamicznie zapamitana tablica znakowa
int len;
char* allocate(const char* s) 		// prywatna funkcja (metoda)
{ char *p = new char[len+1]; 		// przydzia pamici na stercie dla obiektu
if (p==NULL) exit(1); 			// jeli si nie powiodo - koniec
strcpy(p,s); 				// kopiuj tekst na stert
return p; } 				// zwr wskanik do pamici na stercie
  public:
String (int length=0); 			// konstruktor konwersji / domylny
String(const char*); 			// konstruktor konwersji
String(const String& s); 		// konstruktor kopii
~String (); 				// destruktor ma za zadanie zwolni dynamiczn pami
void operator += (const String&); 	// docz (dodaj) inny obiekt
void modify(const char*); 		// zmie zawarto pamici
const char* show() const; 		// zwr wskanik do tablicy
};

String::String(int length)
{ len = length;
str = allocate(""); } 			// kopiuj pusty acuch na stert

String::String(const char* s)
{ len = strlen(s); 			// pomiar dugoci wejciowego tekstu
str = allocate(s); } 			// przydziel pami, skopiuj tekst

String::String(const String& s) 	// konstruktor kopiujcy
{ len = s.len; 				// pomiar dugoci wejciowego tekstu
str = allocate(s.str); } 		// przydziel pami, skopiuj tekst

String::~String()
 { delete str; } 			// zwrot pamici na stercie (nie wskanika!)

void String::operator += (const String& s) 	// parametr przez referencj
{ len = strlen(str) + strlen(s.str); 		// cakowita dugo
char* p = new char[len + 1]; 			// przydziel wystarczajc ilo miejsca na stercie
if (p==NULL) exit(1); 				// sprawd, czy si powiodo
strcpy(p,str); 					// kopiuj pierwsz cz rezultatu
strcat(p,s.str); 				// dodaj drug cz rezultatu
delete str; 					// wana czynno 
str = p; } 					// teraz wskanik p moe znikn

const char* String::show() const 		// chro dane przed zmianami
 { return str; }

void String::modify(const char a[]) 		// bez zarzdzania pamici
{ strncpy(str,a,len-1); 			// ochrona przed przepenieniem
str[len-1] = 0; } 				// poprawne zakoczenie acucha String

int main()
{ 
cout << endl << endl;
String u("This is a test. ");   	// czyli: "To jest tekst - test."
String v("Nothing can go wrong.");   	// czyli: "Nic nie moe pj le."
cout << " u = " << u.show() << endl; 	// rezultat jest OK
cout << " v = " << v.show() << endl; 	// rezultat jest OK
u += v; 				// u.operator+=(v);
cout << " u = " << u.show() << endl; 	// rezultat jest OK
cout << " v = " << v.show() << endl; 	// OK - poprzez referencj
// a tu: "Nasza nadzieja w 'b'":
v.modify("Let us hope for the best."); 	// bez uszkodzenia pamici
{ String t = v; 			// wywoanie konstruktora kopii
cout << " t = " << t.show() << endl; 	// OK - poprawny rezultat
t.modify("Nothing can go wrong."); 	// zmiana tylko t
cout << " t = " << t.show() << endl; 	// OK - poprawny rezultat
cout << " v = " << v.show() << endl; } 	// v si nie zmieni
cout << " v = " << v.show() << endl; 	// t znika, v nienaruszony
return 0;
}
